/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg math */
/*
 * I/O operations for class cVertex
 */

#ifndef iocVertex_hh
#define iocVertex_hh

#include <iostream.h>

#include "cMsgException.hh"	// aquire class cMsgException
#include "cVertex.hh"	// aquire class cVertex

/**
 * An operator to output a cVertex object
 *
 * The vertex is written as <PRE>(x;y;z)\n</PRE>
 *
 * @exception cMsgException
 * @see cVertex
 */
ostream &operator << (ostream &os, const cVertex &v)
	throw (cMsgException);

/**
 * an operator to input a cVertex object
 *
 * The vertex is expected as <PRE>(x;y;z)\n</PRE>
 *
 * @exception cMsgException
 * @see cVertex
 */
istream &operator >> (istream &is, cVertex &v)
	throw (cMsgException);

#endif // ifndef iocVertex_hh
