/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/*
 * I/O operations for class cVertex
 */

#include "iocVertex.hh"

ostream &operator << (ostream &os, const cVertex &v) 
	throw (cMsgException)
{

    os << "(" << v.GetX() << ";" 
              << v.GetY() << ";"
              << v.GetZ() << ")" << endl;

    // quite comfortable... !os is the same as os.fail()
    if (!os) 
        throw cMsgException ("Error writing cVertex.");

    return os;
}

istream &operator >> (istream &is, cVertex &v) 
	throw (cMsgException)
{
    char c;

    is >> c;

    if ((c != '(') || (!is)) 
        throw cMsgException ("Error while reading cVertex: '(' expected.");

    is >> v[0] >> c;

    if ((c != ';') || (!is)) 
        throw cMsgException ("Error while reading cVertex: ';' expected.");

    is >> v[1] >> c;

    if ((c != ';') || (!is)) 
        throw cMsgException ("Error while reading cVertex: ';' expected.");

    is >> v[2] >> c;

    if ((c != ')') || (!is)) 
        throw cMsgException ("Error while reading cVertex: ')' expected.");

    return is;
}

