/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg math */
/*
 * I/O operations for class cMatrix
 */

#ifndef iocMatrix_hh
#define iocMatrix_hh

#include <iostream.h>

#include "cMsgException.hh"
#include "cMatrix.hh"

/**
 * An operator to output a cMatrix object
 *
 * The matrix is written as <PRE>
 * [m<SUB>11</SUB>;m<SUB>12</SUB>;m<SUB>13</SUB>;m<SUB>14</SUB>;
 * m<SUB>21</SUB>;m<SUB>22</SUB>;m<SUB>23</SUB>;m<SUB>24</SUB>;
 * m<SUB>31</SUB>;m<SUB>32</SUB>;m<SUB>33</SUB>;m<SUB>34</SUB>;
 * m<SUB>41</SUB>;m<SUB>42</SUB>;m<SUB>43</SUB>;m<SUB>44</SUB>]\n</PRE>
 *
 * @exception cMsgException
 * @see cMatrix
 */
ostream &operator << (ostream &os, const cMatrix &m) 
	throw (cMsgException);

/**
 * An operator to input a cMatrix object
 *
 * The matrix is expected as <PRE>
 * [m<SUB>11</SUB>;m<SUB>12</SUB>;m<SUB>13</SUB>;m<SUB>14</SUB>;
 * m<SUB>21</SUB>;m<SUB>22</SUB>;m<SUB>23</SUB>;m<SUB>24</SUB>;
 * m<SUB>31</SUB>;m<SUB>32</SUB>;m<SUB>33</SUB>;m<SUB>34</SUB>;
 * m<SUB>41</SUB>;m<SUB>42</SUB>;m<SUB>43</SUB>;m<SUB>44</SUB>]\n</PRE>
 *
 * @exception cMsgException
 * @see cMatrix
 */
istream &operator >> (istream &is, cMatrix &m)
	throw (cMsgException);

#endif	// ifndef iocMatrix_hh
