/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/*
 * I/O operations for class cMatrix
 */

#include "iocMatrix.hh"

ostream &operator << (ostream &os, const cMatrix &m) 
	throw (cMsgException)
{
    
    os << "[";

    for (int row = 0; row < 4; row++)
        for (int col = 0; col < 4; col++) {
            os << m.mMatrix[row][col];

            if (col != 3) {
                os << ";";
            } else {

                if (row != 3) {
                    os << endl;
                }

            }

        }

    os << ']' << endl;

    if (!os) 
        throw cMsgException ("Error writing mMatrix.");

    return os;
}

istream &operator >> (istream &is, cMatrix &m) 
	throw (cMsgException)
{
    char c;

    is >> c;

    if ((c != '[') || (!is)) 
        throw cMsgException ("Error reading cMatrix: '[' expected.");

    for (int row = 0; row < 4; row++)
        for (int col = 0; col < 4; col++) {
            is >> m.mMatrix[row][col];

            if (!is) 
                throw cMsgException ("Error reading cMatrix: Float expected.");

            if (col != 3) {
                is >> c;   // read delimiter

                if ((c != ';') || (!is))
                    throw cMsgException ("Error reading cMatrix: ';' expected.");
            }

        }

    is >> c;   // read final ']'

    if ((!is) || (c != ']'))
        throw cMsgException ("Error reading cMatrix: ']' expected.");

    return is;
}

