/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg common*/
/**
 * locally common definitions, macros and included headers
 *
 * @pkgdoc common
 */

#ifndef common_h
#define common_h

#include <string.h>
#include <math.h>
#include <GL/gl.h>

#if GL_VERSION_1_1
#else
#error This project only works with OpenGL 1.1 or later.
#endif

//#define DEBUG 1

#ifndef DEBUG
#define DEBUG 0
#endif

#ifndef M_PI
/** There seems to be no portable way to get the value of PI! This sucks. */
const GLfloat M_PI = 3.1415926535897932384626433832795029;
#endif

// within which range we consider two floats as equal?
#define FLOAT_EQUAL_RANGE 1e-6
#define FLOATS_EQUAL(a,b) (fabs (a-b) < FLOAT_EQUAL_RANGE)

#ifndef sqr
#define sqr(x) ((x)*(x))
#endif	// ifndef sqr

#if DEBUG
#include <iostream.h>

#define DEBUG_MSG(x) cerr << x << " in " ## __FILE__ ## " at line " ## '"' ## __LINE__ ## '"';
#define DEBUG_MSG(x) cerr << x << " in " ## __FILE__ ## " at line " ## '"' ## __LINE__ ## '"';

#define DEBUG_OUT(x) cerr << x << endl;
#define DEBUG_OUT2(x,y) cerr << x << y << endl;

#define ENTER_METHOD(classname) cerr << '"' << classname << "\" called, this=" << hex << (void *)this << dec << endl;

#define ENTER_OBJECT_METHOD(classname) \
	cerr << "object \"" << GetName() << "\": "; \
	ENTER_METHOD(classname)

#else	// if DEBUG

#define DEBUG_MSG(x)	(void)0
#define DEBUG_OUT(x)	(void)0
#define DEBUG_OUT2(x,y)	(void)0
#define ENTER_METHOD(classname) (void)0
#define ENTER_OBJECT_METHOD(classname) (void)0

#endif	// if DEBUG


#endif	// ifndef common_h
