/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg events.cEventConsumer.cWorldControl */
/**
 * This is a class which belongs mainly to the application.
 * It is responsible for translating a lot of events generated
 * by cEventInput into high-level events for cWorld and it's
 * siblings.
 *
 *@pkgdoch events.cEventConsumer.cWorldControl
 */

#ifndef cWorldControl_hh
#define cWorldControl_hh

#include "cEventConsumer.hh"
// get constants for events dedicated to objects
#include "cInteractiveObject.hh"
// get constants for raw input
#include "cEventInput.hh"

/**
 * class for translating low-level events into high-level ones
 */
class cWorldControl
:	public cEventConsumer
{
public:
	/**
	 * default constructor
	 	*/
	cWorldControl (
		cEventDispatcher *disp);

	/**
	 * destructor
	 	*/
	virtual ~cWorldControl ();

protected:
	/**
	 * event receiver (called by dispatcher)
	 	*/
	virtual int ReceiveEvent (const cEvent &event);

	/**
	 * current state of mouse buttons
	 	*/
	int mMouseButtonState;

	typedef enum eControlMode {
		CM_WALK,
		CM_ORBIT,
		CM_ROTATE_OBJECT,
		CM_MOVE_OBJECT
	} teControlMode;

	/**
	 * current control mode
	 	*/
	teControlMode mControlMode;

	/**
	 * remeber whether we rotate/move within object's or global coord.
	 	*/
	bool mGlobalMode;
};
#endif	//ifndef cWorldControl_hh
