/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg events.cEvent.cVertexEvent*/
/**
 * a cNamedEvent which carries a cVertex
 *
 * @pkgdoc events.cEvent.cVertexEvent
 */

#ifndef cVertexEvent_hh
#define cVertexEvent_hh

#include "cEvent.hh"
#include "cVertex.hh"

/**
 * a cNamedEvent with a payload (a cVertex)
 */
class cVertexEvent : public cEvent
{
public:
	/**
	 * constructor which takes the event's name
	 	* @param name string which contains the event's name
		*/
	cVertexEvent (
		const string &type = "cVertexEvent");

	/**
	 * constructor which takes the event's name
	 	* @param name string which contains the event's name
		* @param v vertex to transport (optional)
		*/
	cVertexEvent (
		const string &type, 
		const cVertex &v);

	/**
	 * constructor which takes the event's name
	 	* @param name string which contains the event's name
		* @param x x-component of vertex
		* @param y y-component of vertex
		* @param z z-component of vertex
		*/
	cVertexEvent (
		const string &type, 
		GLfloat x,
		GLfloat y = 0,
		GLfloat z = 0);

	/**
	 * copy constructor
	 	*/
	cVertexEvent (const cVertexEvent &e);

	/**
	 * destructor
	 	*/
	virtual ~cVertexEvent ();

	/**
	 * clone function
	 	* @return pointer to new allocated cVertexEvent
		*/
	virtual cVertexEvent *Clone () const;

	/**
	 * allow accessing the payload
	 	* @return const reference to cVertex containing the payload
		*/
	virtual const cVertex &GetVertex () const;

protected:
	/**
	 * the stored vertex
	 	*/
	cVertex mVertex;
};

#endif	// ifndef cVertexEvent_hh
