/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**
 * implementation of a cEvent which carries a cVertex
 */

#include "cVertexEvent.hh"

/**
 * constructor which takes the event's name
 	* @param type string which contains the event's name
	*/
cVertexEvent::cVertexEvent (
	const string &type)
:	cEvent (type)
{
}

/**
 * constructor which takes the event's name
 	* @param name string which contains the event's name
	*/
cVertexEvent::cVertexEvent (
	const string &type, 
	const cVertex &v)
:	cEvent (type),
	mVertex (v)
{
}

/**
 * constructor which takes the event's name
	*/
cVertexEvent::cVertexEvent (
	const string &type, 
	GLfloat x,
	GLfloat y,
	GLfloat z)
:	cEvent (type),
	mVertex (x, y, z)
{
}

/**
 * copy constructor
 	*/
cVertexEvent::cVertexEvent (
	const cVertexEvent &e)
:	cEvent (e),
	mVertex (e.mVertex)
{
}

/**
 * destructor
 	*/
cVertexEvent::~cVertexEvent ()
{
}

/**
 * clone function
 	* @return pointer to new allocated cVertexEvent
	*/
cVertexEvent *cVertexEvent::Clone () const
{
	return new cVertexEvent (mName, mVertex);
}

/**
 * allow accessing the payload
 	* @return const reference to cVertex containing the payload
	*/
const cVertex &cVertexEvent::GetVertex () const
{
	return mVertex;
}

