/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg events.cEvent.cRotationEvent*/
/**
 * a cNamedEvent which carries a cQuaternion
 *
 * @pkgdoc events.cEvent.cRotationEvent
 */

#ifndef cRotationEvent_hh
#define cRotationEvent_hh

#include "cEvent.hh"
#include "cQuaternion.hh"

/**
 * a cNamedEvent with a payload (a cQuaternion)
 */
class cRotationEvent : public cEvent
{
public:
	/**
	 * constructor which takes the event's name
	 	* @param name string which contains the event's name
		*/
	cRotationEvent (
		const string &type = "cRotationEvent");

	/**
	 * constructor w/ initialization
	 	* @param name string which contains the event's name
		* @param angle angle in degree
		* @param axis axis to turn around
		*/
	cRotationEvent (
		const string &type,
		GLfloat angle,
		const cVertex &axis);

	/**
	 * copy constructor
	 	*/
	cRotationEvent (const cRotationEvent &e);

	/**
	 * destructor
	 	*/
	virtual ~cRotationEvent ();

	/**
	 * clone function
	 	* @return pointer to new allocated cRotationEvent
		*/
	virtual cRotationEvent *Clone () const;

	/**
	 * allow accessing the payload
	 	* @return angle to turn around
		*/
	virtual GLfloat GetAngle () const;

	/**
	 * allow accessing the payload
	 	* @return axis to turn around
		*/
	virtual const cVertex &GetAxis () const;

protected:
	/**
	 * the stored angle
	 	*/
	GLfloat mAngle;
	/**
	 * the stored axis
	 	*/
	cVertex mAxis;
};

#endif	// ifndef cRotationEvent_hh
