/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**
 * implementation of cRotationEvent
 */

#include "cRotationEvent.hh"

/**
 * constructor which takes the event's name
 	* @param name string which contains the event's name
	*/
cRotationEvent::cRotationEvent (
	const string &type)
:	cEvent (type)
{
}

/**
 * constructor which takes the event's name
 	* @param name string which contains the event's name
	*/
cRotationEvent::cRotationEvent (
	const string &type, 
	const GLfloat angle,
	const cVertex &axis)
:	cEvent (type),
	mAngle (angle),
	mAxis (axis)
{
}

/**
 * copy constructor
 	*/
cRotationEvent::cRotationEvent (
	const cRotationEvent &e)
:	cEvent (e),
	mAngle (e.mAngle),
	mAxis (e.mAxis)
{
}

/**
 * destructor
 	*/
cRotationEvent::~cRotationEvent ()
{
}

/**
 * clone function
 	* @return pointer to new allocated cRotationEvent
	*/
cRotationEvent *cRotationEvent::Clone () const
{
	return new cRotationEvent (mName, mAngle, mAxis);
}

/**
 * allow accessing the payload
	*/
GLfloat cRotationEvent::GetAngle () const
{
	return mAngle;
}

/**
 * allow accessing the payload
	*/
const cVertex &cRotationEvent::GetAxis () const
{
	return mAxis;
}

