/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg cException.cMsgException*/
/**
 * simple exception handling (just w/ error message)
 *
 * @pkgdoc cException.cMsgException
 */

#ifndef cMsgException_hh
#define cMsgException_hh

#include <string>			// include STL strings
#include "cException.hh"	// aquire class cException

/**
 * very simple exception class 
 * (just contains a simple string explaining what went wrong)
 *
 */
class cMsgException : public cException {
private:
	// that's just our internal representation
	//typedef basic_string <char> string;

    string message;

public:
	/**
	 * default constructor
	 	*/
    cMsgException ();

	/**
	 * constructor taking an error message
	 	* @param m error message/explanation
	 	*/
    cMsgException (char *m);

	/**
	 * destructor - frees stored message
	 	*/
    virtual ~cMsgException ();
    
	/**
	 * explain what went wrong
	 	* @return zero terminated string with stored error message
	 	*/
    virtual const char *Explanation () const;

};

#endif	// ifndef cMsgException_hh
