/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg events.cEvent.cMousePressEvent*/
/**
 * an event for transporting a mouse button action
 *
 * @pkgdoc events.cEvent.cMousePressEvent
 */

#ifndef cMousePressEvent_hh
#define cMousePressEvent_hh

#include "cEvent.hh"
#include "cVertex.hh"

/**
 * a cEvent with a payload (a mouse button state change)
 */
class cMousePressEvent 
: public cEvent
{
public:
	/**
	 * constructor w/ initialization
	 	* @param name string which contains the event's name
		*/
	cMousePressEvent (
		const string &name = "cMousePressEvent");

	/**
	 * constructor w/ initialization
	 	* @param name string which contains the event's name
		* @param button which button was affected
		* @param state how did it change state (GLUT_UP/GLUT_DOWN)
		* @param x x-pos of mouse
		* @param y y-pos of mouse
		* @param z z-pos of mouse (if any)
		*/
	cMousePressEvent (
		const string &name, 
		int button,
		int state,
		GLfloat x,
		GLfloat y,
		GLfloat z = 0);

	/**
	 * constructor w/ initialization
	 	* @param name string which contains the event's name
		* @param button which button was affected
		* @param state how did it change state (GLUT_UP/GLUT_DOWN)
		* @param pos cVertex pos of mouse
		*/
	cMousePressEvent (
		const string &name, 
		int button,
		int state,
		const cVertex &pos);

	/**
	 * copy constructor
	 	*/
	cMousePressEvent (const cMousePressEvent &e);

	/**
	 * destructor
	 	*/
	virtual ~cMousePressEvent ();

	/**
	 * clone function
	 	* @return pointer to new allocated cMousePressEvent
		*/
	virtual cMousePressEvent *Clone () const;

	/**
	 * allow accessing the stored mouse status
	 	* @param button reference to int where the affected buttons are
		* written to
		* @param state reference to int where the new state is written to
		*/
	virtual void GetButtonState (int &button, int &state) const;

	/**
	 * allow accessing the stored mouse position
	 	* @return const reference to cVertex with stored position
		*/
	virtual const cVertex &GetPos () const;

protected:
	/** stored button mask */
	int mButton;
	/** button status */
	int mStatus;
	/** mouse position */
	cVertex mPos;
};

#endif	// ifndef cMousePressEvent_hh
