/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**
 * implementation of cMousePressEvent
 *
 * @pkgdoc events.cEvent.cMousePressEvent
 */

#include "cMousePressEvent.hh"

/**
 * constructor
	*/
cMousePressEvent::cMousePressEvent (
	const string &name)
:	cEvent (name)
{
}

/**
 * constructor
	*/
cMousePressEvent::cMousePressEvent (
	const string &name, 
	int button,
	int state,
	GLfloat x,
	GLfloat y,
	GLfloat z)
:	cEvent (name),
	mButton (button),
	mStatus (state),
	mPos (x, y, z)
{
}

/**
 * constructor
	*/
cMousePressEvent::cMousePressEvent (
	const string &name, 
	int button,
	int state,
	const cVertex &pos)
:	cEvent (name),
	mButton (button),
	mStatus (state),
	mPos (pos)
{
}
/**
 * copy constructor
 	*/
cMousePressEvent::cMousePressEvent (const cMousePressEvent &e)
:	cEvent (e),
	mButton (e.mButton),
	mStatus (e.mStatus),
	mPos (e.mPos)
{
}

/**
 * destructor
 	*/
cMousePressEvent::~cMousePressEvent ()
{
}

/**
 * clone function
 	* @return pointer to new allocated cMousePressEvent
	*/
cMousePressEvent *cMousePressEvent::Clone () const
{
	return new cMousePressEvent (mName, mButton, mStatus, mPos);
}

/**
 * return button state
	*/
void cMousePressEvent::GetButtonState (int &button, int &state) const
{
	button = mButton;
	state = mStatus;
}

/**
 * return mouse pos
	*/
const cVertex &cMousePressEvent::GetPos () const
{
	return mPos;
}
