/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**
 * implementation of class cMaterial
 */

#include "cMaterial.hh"

/**
 * default constructor
 	*/
cMaterial::cMaterial (const char *name)
:	cObject (name),
	mShininess (0)
{
	ENTER_OBJECT_METHOD ("cMaterial::cMaterial ()");
}

/**
 * constructor with full initialization
 	*/
cMaterial::cMaterial (
	const cADSEColor &color,
	const int shininess,
	const char *name)
:	cObject (name),
	mColor (color),
	mShininess (shininess)
{
	ENTER_OBJECT_METHOD ("cMaterial::cMaterial ()");
}

/**
 * destructor
 	*/
cMaterial::~cMaterial ()
{
	ENTER_OBJECT_METHOD ("cMaterial::~cMaterial ()");
}

int cMaterial::Init ()
{
	ENTER_OBJECT_METHOD ("cMaterial::Init ()");

	return cObject::Init ();
}

/**
 * enable material's properties
 	*/
void cMaterial::StartMaterialUse ()
{
	ENTER_OBJECT_METHOD ("cMaterial::StartMaterialUse ()");

	// TODO: Support backside material
	glGetMaterialfv (GL_FRONT, GL_AMBIENT, mOldFrontColor.wAmbient());
	glMaterialfv (GL_FRONT, GL_AMBIENT, mColor.Ambient());

	glGetMaterialfv (GL_FRONT, GL_DIFFUSE, mOldFrontColor.wDiffuse());
	glMaterialfv (GL_FRONT, GL_DIFFUSE, mColor.Diffuse());

	glGetMaterialfv (GL_FRONT, GL_SPECULAR, mOldFrontColor.wSpecular());
	glMaterialfv (GL_FRONT, GL_SPECULAR, mColor.Specular());

	glGetMaterialfv (GL_FRONT, GL_EMISSION, mOldFrontColor.wEmissive());
	glMaterialfv (GL_FRONT, GL_EMISSION, mColor.Emissive());

	glGetMaterialfv (GL_FRONT, GL_SHININESS, &mOldFrontShininess);
	glMateriali (GL_FRONT, GL_SHININESS, mShininess);

}

/**
 * disable materials properties (restore original settings)
 	*/
void cMaterial::EndMaterialUse ()
{
	ENTER_OBJECT_METHOD ("cMaterial::EndMaterialUse ()");

	glMaterialfv (GL_FRONT, GL_AMBIENT, mOldFrontColor.Ambient());
	glMaterialfv (GL_FRONT, GL_DIFFUSE, mOldFrontColor.Diffuse());
	glMaterialfv (GL_FRONT, GL_SPECULAR, mOldFrontColor.Specular());
	glMaterialf (GL_FRONT, GL_SHININESS, mOldFrontShininess);
}

/**
 * activation function
 	*/
void cMaterial::Activate ()
{
	ENTER_OBJECT_METHOD ("cMaterial::Activate ()");

	StartMaterialUse ();

	// activate all childs
	cObject::Activate ();
}

/**
 * deactivation function
 	*/
void cMaterial::Deactivate ()
{
	ENTER_OBJECT_METHOD ("cMaterial::Deactivate ()");

	EndMaterialUse();
}

