/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg events.cEvent.cKeyEvent*/
/**
 * an event for transporting a key stroke
 *
 * @pkgdoc events.cEvent.cKeyEvent
 */

#ifndef cKeyEvent_hh
#define cKeyEvent_hh

#include "cEvent.hh"

/**
 * a cEvent with a payload (a key stroke)
 */
class cKeyEvent 
: public cEvent
{
public:
	/**
	 * constructor w/ initialization
	 	* @param name string which contains the event's name
		* @param key ASCII key (0 if special)
		* @param special special key if key==0
		* @param modifiers active modifiers (CTRL etc.)
		*/
	cKeyEvent (
		const string &name = "cKeyEvent", 
		unsigned char key = 0,
		int special = 0,
		int modifiers = 0);

	/**
	 * constructor w/ initialization
	 	* @param name string which contains the event's name
		* @param key ASCII key (0 if special)
		* @param special special key if key==0
		* @param modifiers active modifiers (CTRL etc.)
		*/
	cKeyEvent (
		unsigned char key = 0,
		int special = 0,
		int modifiers = 0,
		const string &name = "cKeyEvent");

	/**
	 * copy constructor
	 	*/
	cKeyEvent (const cKeyEvent &e);

	/**
	 * destructor
	 	*/
	virtual ~cKeyEvent ();

	/**
	 * clone function
	 	* @return pointer to new allocated cKeyEvent
		*/
	virtual cKeyEvent *Clone () const;

	/**
	 * allow accessing the stored key
	 	* @return ASCII key value (zero for special key)
		*/
	virtual unsigned char GetKey () const;

	/**
	 * allow accessing the stored special key
	 	* @return special key value (zero for ASCII key)
		*/
	virtual int GetSpecialKey () const;

	/**
	 * allow accessing the stored key modifiers
	 	* @return modifiers in action when key was pressed
		*/
	virtual int GetKeyModifiers () const;

protected:
	/**
	 * the key to transport
	 	*/
	unsigned char mKey;
	/**
	 * special key to transport
	 	*/
	int mSpecial;
	/**
	 * modifiers to transport
	 	*/
	int mModifiers;
};

#endif	// ifndef cKeyEvent_hh
