/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**
 * implementation of cKeyEvent
 *
 * @pkgdoc events.cEvent.cKeyEvent
 */

#include "cKeyEvent.hh"

/**
 * constructor which takes the event's name
 	* @param name string which contains the event's name
	* @param key ASCII key (0 if special)
	* @param special special key if key==0
	* @param modifiers active modifiers (CTRL etc.)
	*/
cKeyEvent::cKeyEvent (
	const string &name, 
	unsigned char key,
	int special,
	int modifier)
:	cEvent (name),
	mKey (key),
	mSpecial (special),
	mModifiers (modifier)
{
}

cKeyEvent::cKeyEvent (
	unsigned char key,
	int special,
	int modifier,
	const string &name)
:	cEvent (name),
	mKey (key),
	mSpecial (special),
	mModifiers (modifier)
{
}
/**
 * copy constructor
 	*/
cKeyEvent::cKeyEvent (const cKeyEvent &e)
:	cEvent (e),
	mKey (e.mKey),
	mSpecial (e.mSpecial),
	mModifiers (e.mModifiers)
{
}

/**
 * destructor
 	*/
cKeyEvent::~cKeyEvent ()
{
}

/**
 * clone function
 	* @return pointer to new allocated cKeyEvent
	*/
cKeyEvent *cKeyEvent::Clone () const
{
	return new cKeyEvent (mName, mKey, mSpecial, mModifiers);
}

/**
 * return key
	*/
unsigned char cKeyEvent::GetKey () const
{
	return mKey;
}

/**
 * return special
	*/
int cKeyEvent::GetSpecialKey () const
{
	return mSpecial;
}

/**
 * return modifier
	*/
int cKeyEvent::GetKeyModifiers () const
{
	return mModifiers;
}

