/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg cObject.cVisibleObject.cInteractiveObject */
/**
 * An object which is able to receive several (predefined) events
 * and react appropriately.
 *
 *@pkgdoc cObject.cVisibleObject.cInteractiveObject
 */

#ifndef cInteractiveObject_hh
#define cInteractiveObject_hh

#include "cVisibleObject.hh"
#include "cEventConsumer.hh"
#include "cVertexEvent.hh"
#include "cAddressEvent.hh"
#include "cRotationEvent.hh"

/**
 * A class for a visible object which is able to react on several
 * events.
 */
class cInteractiveObject 
	: public cVisibleObject, public cEventConsumer
{
//LIFETIME
public:
	/**
	 * constructor with initialization
	 	* @param disp cEventDispatcher to register/unregister at
		* @param name optional name of object (defaults to class name)
		*/
	cInteractiveObject (cEventDispatcher *disp, const char *name = NULL);

	/**
	 * constructor with initialization
	 	* @param disp cEventDispatcher to register/unregister at
		* @param pos initial position of object
		* @param name optional name of object (defaults to class name)
		*/
	cInteractiveObject (
		cEventDispatcher *disp, 
		const cVertex &pos, 
		const char *name = NULL);

	/**
	 * constructor with initialization
	 	* @param disp cEventDispatcher to register/unregister at
		* @param pos initial position of object
		* @param rot initial rotation of object
		* @param name optional name of object (defaults to class name)
		*/
	cInteractiveObject (
		cEventDispatcher *disp, 
		const cVertex &pos, 
		const cQuaternion &rot,
		const char *name = NULL);

	/**
	 * copy constructor
	 	*/
	cInteractiveObject (const cInteractiveObject &cio);

	/**
	 * destructor
	 	*/
	~cInteractiveObject ();

	/**
	 * perform initialization
	 	*/
	virtual int Init ();

	/**
	 * event receiver
	 	* @param event cEvent to receive/check
	 	*/
	virtual int ReceiveEvent (const cEvent &event);

protected:
	/**
	 * return default class name as char *
	 	* @see cObject::GetName
	 	*/
	virtual const char *GetDefaultName () const
	{
		return "cInteractiveObject";
	};

	/**
	 * subscribe to any event the active object is interested in
		*/
	virtual void SubscribeToActiveEvents ();

	/**
	 * subscribe to any event the object is interested in the whole time
		*/
	virtual void SubscribeToPassiveEvents ();

	/**
	 * unsubscribe from any event the active object is interested in
		*/
	virtual void UnsubscribeFromActiveEvents ();

	/**
	 * unsubscribe from any event the object is interested in the whole time
		*/
	virtual void UnsubscribeFromPassiveEvents ();

	/**
	 * remember whether we are currently selected "active" object
	 	*/
	bool mSelected;
};

#endif	//ifndef cInteractiveObject_hh
