/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg events.cEvent.cIntEvent*/
/**
 * an event for transporting an int
 *
 * @pkgdoc events.cEvent.cIntEvent
 */

#ifndef cIntEvent_hh
#define cIntEvent_hh

#include "cEvent.hh"

/**
 * a cNamedEvent with a payload (an integer)
 */
class cIntEvent 
: public cEvent
{
public:
	/**
	 * constructor which takes the event's name
	 	* @param name string which contains the event's name
		* @param value value to transport
		*/
	cIntEvent (
		const string &name = "cIntEvent", 
		int value = 0);

	/**
	 * copy constructor
	 	*/
	cIntEvent (const cIntEvent &e);

	/**
	 * destructor
	 	*/
	virtual ~cIntEvent ();

	/**
	 * clone function
	 	* @return pointer to new allocated cIntEvent
		*/
	virtual cIntEvent *Clone () const;

	/**
	 * allow accessing the payload
	 	* @return transported value
		*/
	virtual int GetValue () const;

protected:
	/**
	 * the integer to transport
	 	*/
	int mValue;
};

#endif	// ifndef cIntEvent_hh
