/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**
 * implementation of cIntEvent
 *
 * @pkgdoc events.cEvent.cIntEvent
 */

#include "cIntEvent.hh"

/**
 * constructor which takes the event's name
 	* @param name string which contains the event's name
	* @param address void ptr to addressee
	*/
cIntEvent::cIntEvent (
	const string &name, 
	int value)
:	cEvent (name),
	mValue (value)
{
}

/**
 * copy constructor
 	*/
cIntEvent::cIntEvent (const cIntEvent &e)
:	cEvent (e),
	mValue (e.mValue)
{
}

/**
 * destructor
 	*/
cIntEvent::~cIntEvent ()
{
}

/**
 * clone function
 	* @return pointer to new allocated cIntEvent
	*/
cIntEvent *cIntEvent::Clone () const
{
	return new cIntEvent (mName, mValue);
}

/**
 * allow accessing the payload
 	* @return transported value
	*/
int cIntEvent::GetValue () const
{
	return mValue;
}

