/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg cException */
/**
 * abstract base class for exception handling
 * @pkgdoc cException
 */
#ifndef cException_hh
#define cException_hh

/**
 * abstract base class for exception handling
 *
 * This is only an abstract class for exception handling. It's mainly here
 * for matters of completeness as it does not contain any functionality.
 *
 * @see cMsgException
 */
class cException {
// LIFECYCLE
public:
	/**
	 * constructor
		*/
    cException ();

	/**
	 * destructor - made virtual to allow deriving.
		*/
    virtual ~cException ();

// ACCESS
	/**
	 * Explain what caused the exception.
		*/
    virtual const char *Explanation () const = 0;
};

#endif	// ifndef cException_hh
