/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg events.cEventProducer*/
/**
 * an abstract class which produces cEvents
 *
 * #include "cEventProducer.hh"
 *
 *@pkgdoc events.cEventProducer
 */

#ifndef cEventProducer_hh
#define cEventProducer_hh

#include "cEvent.hh"
#include "cEventDispatcher.hh"

/**
 * an abstract event producer class
 	*
	* When destroying an cEventDispatcher, take care to destroy all
	* producers first which send their events to it!
	*
	* @see cEventDispatcher
 	*/
class cEventProducer
{
// LIFETIME
public:
	/**
	 * default constructor
	 	* @param disp pointer to cEventDispatcher object which will receive
		* the produced events via SendEvent()
	 	*/
	cEventProducer (cEventDispatcher *disp);

	/**
	 * destructor
	 	*/
	virtual ~cEventProducer ();

	/**
	 * method to send an event
	 	* This is more a convenience function.
		* (might be called by inherited functions to get rid of their event)
	 	*
		* @param event cEvent (or derived) object to send
	 	*/
	virtual void SendEvent (const cEvent &event);

protected:
	cEventDispatcher *mDispatcher;
};

#endif //ifndef cEventProducer_hh
