/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**
 * an abstract class which produces cEvents
 *
 * #include "cEventProducer.hh"
 *
 */

#include "cEventProducer.hh"

/**
 * default constructor
 	*/
cEventProducer::cEventProducer (cEventDispatcher *disp)
{
	mDispatcher = disp;
}


/**
 * destructor
 	*/
cEventProducer::~cEventProducer ()
{
}

/**
 * event sending function
 	*/
void cEventProducer::SendEvent (const cEvent &event)
{
	// just delegate it to the dispatcher
	mDispatcher->SendEvent (event);
}

