/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg events.cEventProducer.cEventInput*/
/**
 * This class provides the interface to GLUTs input callbacks.
 *
 * #include "cEventInput.hh"
 *
 * They are implemented as static functions as an object's method cannot
 * be called from C.
 *
 *@pkgdoc events.cEventProducer.cEventInput
 */

#ifndef cEventInput_hh
#define cEventInput_hh

#include "cEventProducer.hh"

class cEventInput
:	public cEventProducer
{
public:
	/**
	 * constructor (registers callback with GLUT)
	 	* @param disp cEventDispatcher to send all events to
		*/
	cEventInput (cEventDispatcher *disp);

	/**
	 * copy constructor
	 	*/
	cEventInput (const cEventInput &e);

	/**
	 * destructor
	 	*/
	virtual ~cEventInput ();

	/**
	 * send a key event away
	 	* @param key standard ASCII of pressed key (0 = special key)
		* @param special special key code, if key==0
		* @param modifiers active key modifiers (CTRL, etc.)
		*/
	virtual void SendKeyEvent (
		unsigned char key,
		int special,
		int modifiers);

	/**
	 * send a mouse move
	 	* @param x x coordinate of mouse
		* @param y y coordinate of mouse
		*/
	virtual void SendMouseMoveEvent (int x, int y);

	/**
	 * send a mouse button press
	 	* @param button which button was affected
		* @param state was it pressed or released (GLUT_UP/GLUT_DOWN)
		* @param x x pos of mouse
		* @param y y pos of mouse
		*/
	virtual void SendMousePressEvent (
		int button,
		int state,
		int x, int y);

};
#endif	//ifndef cEventInput_hh
