/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg events.cEventConsumer*/
/**
 * a class which consumes (receives) cEvents
 *
 * #include "cEventConsumer.hh"
 *
 *@pkgdoc events.cEventConsumer
 */

#ifndef cEventConsumer_hh
#define cEventConsumer_hh

// forward declaration
class cEventConsumer;

#include "cEvent.hh"
#include "cEventDispatcher.hh"

/**
 * a class which consumes cEvents
 	*/
class cEventConsumer
{
// LIFETIME
public:
	/**
	 * default constructor
	 	*/
	cEventConsumer (class cEventDispatcher *disp);

	/**
	 * destructor
	 	*/
	virtual ~cEventConsumer ();

	/**
	 * receive an event and tell the caller whether it was accepted
		* @param event const reference to cEvent object of event to
		* check
		* @return  0 == success (event accepted), 
		*         -1 == denied (event not accepted)
		*/
	virtual int ReceiveEvent (const cEvent &event);

protected:
	/**
	 * the dispatcher to unregister at if we're destroyed.
	 * (we may also send events to it)
	 */
	class cEventDispatcher *mDispatcher;
};

#endif //ifndef cEventConsumer_hh
