/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**
 * an abstract class which consumes cEvents
 *
 * #include "cEventConsumer.hh"
 *
 */

#include "cEventConsumer.hh"

/**
 * default constructor
 	*/
cEventConsumer::cEventConsumer (
	cEventDispatcher *dispatcher)
{
	mDispatcher = dispatcher;
}


/**
 * destructor
 	*/
cEventConsumer::~cEventConsumer ()
{
	// tell the dispatcher that we're gone
	mDispatcher->UnregisterConsumer (this);
}

/**
 * event receiving function
 	*/
int cEventConsumer::ReceiveEvent (const cEvent &event)
{
	cerr << "received event of type " << event << endl;
	// accept any events
	return 0;
}

