/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**
 * implementation of class cEnvTextureMaterial
 */

#include <GL/gl.h>

#include "cEnvTextureMaterial.hh"

/**
 * default constructor
 	*/
cEnvTextureMaterial::cEnvTextureMaterial (const char *name)
:	cTextureMaterial (name)
{
	ENTER_OBJECT_METHOD ("cEnvTextureMaterial::cEnvTextureMaterial ()");
}

/**
 * constructor with material initialization
 	*/
cEnvTextureMaterial::cEnvTextureMaterial (
	const cADSEColor &color,
	const int shininess,
	const char *name)
:	cTextureMaterial (color, shininess, name)
{
	ENTER_OBJECT_METHOD ("cEnvTextureMaterial::cEnvTextureMaterial ()");
}

/**
 * constructor with material initialization
 	*/
cEnvTextureMaterial::cEnvTextureMaterial (
	const char *texture,
	const cADSEColor &color,
	const int shininess,
	const char *name)
:	cTextureMaterial (texture, color, shininess, name)
{
	ENTER_OBJECT_METHOD ("cEnvTextureMaterial::cEnvTextureMaterial ()");
}

/**
 * constructor with material initialization
 	*/
cEnvTextureMaterial::cEnvTextureMaterial (
	const char *texture,
	bool usemipmaps,
	const cADSEColor &color,
	const int shininess,
	const char *name)
:	cTextureMaterial (texture, usemipmaps, color, shininess, name)
{
	ENTER_OBJECT_METHOD ("cEnvTextureMaterial::cEnvTextureMaterial ()");
}

/**
 * copy-constructor
 	*/
cEnvTextureMaterial::cEnvTextureMaterial (const cEnvTextureMaterial &ctm)
:	cTextureMaterial ((const cTextureMaterial &)ctm)
{
	ENTER_OBJECT_METHOD ("cEnvTextureMaterial::cEnvTextureMaterial (const cEnvTextureMaterial &)");
}

/**
 * destructor
 	*/
cEnvTextureMaterial::~cEnvTextureMaterial ()
{
	ENTER_OBJECT_METHOD ("cEnvTextureMaterial::~cEnvTextureMaterial ()");
	// all done by ~cTextureMaterial
}

/**
 * initialization
 	*/
int cEnvTextureMaterial::Init ()
{
	ENTER_OBJECT_METHOD ("cEnvTextureMaterial::Init ()");

	return cTextureMaterial::Init ();
}

/**
 * enable material's properties
 	*/
void cEnvTextureMaterial::StartMaterialUse ()
{
	ENTER_OBJECT_METHOD ("cEnvTextureMaterial::StartMaterialUse ()");

	cTextureMaterial::StartMaterialUse ();

	// do we have a texture?
	if ((mTextureName != 0) && (mTextureData != NULL))
	{
		glGetTexGeniv (GL_S, GL_TEXTURE_GEN_MODE, &mOldSMode);
		glGetTexGeniv (GL_T, GL_TEXTURE_GEN_MODE, &mOldTMode);
		mOldSState = glIsEnabled (GL_TEXTURE_GEN_S);
		mOldTState = glIsEnabled (GL_TEXTURE_GEN_T);

		glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
		glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);

		if (mOldSState != GL_TRUE)
		{
			glEnable (GL_TEXTURE_GEN_S);
		}

		if (mOldTState != GL_TRUE)
		{
			glEnable (GL_TEXTURE_GEN_T);
		}

	}

}

/**
 * disable materials properties (restore original settings)
 	*/
void cEnvTextureMaterial::EndMaterialUse ()
{
	ENTER_OBJECT_METHOD ("cEnvTextureMaterial::EndMaterialUse ()");

	// we might not have a texture at all
	if ((mTextureName != 0) && (mTextureData != NULL))
	{
		glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, mOldSMode);
		glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, mOldTMode);

		if (mOldSState != GL_TRUE)
		{
			glDisable (GL_TEXTURE_GEN_S);
		}

		if (mOldTState != GL_TRUE)
		{
			glDisable (GL_TEXTURE_GEN_T);
		}

	}

	cTextureMaterial::EndMaterialUse ();
}

