/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg cObject.cVisibleObject.cInteractiveObject.cLight.cDirectionLight*/
/**
 * a class for managing a directional OpenGL light
 *
 * #include "cDirectionLight.hh"
 *
 * -lMesaGL or -lGL
 *
 * @see cInteractiveObject
 * @pkgdoc cObject.cVisibleObject.cInteractiveObject.cLight.cDirectionLight
 */

#ifndef cDirectionLight_hh
#define cDirectionLight_hh

// include class cLight to derive from
#include "cLight.hh"

// include class cColor representing an RGB(A) color for use
// with OpenGL
#include "cADSEColor.hh"

// include common project macros, definitions and headers
#include "common.hh"

/**
 * A class for an OpenGL directional light.
	* The inherited mRotation quaternion is used (in contrast to cLight)
	* - it modifies the light's direction.
	*/
class cDirectionLight 
:	public cLight
{
public:
	/**
	 * default constructor
	 	*/
	cDirectionLight (
		cEventDispatcher *disp,
		const char *name = NULL);

#if DEBUG
	/**
	 * copy constructor (inherited)
	 	*/
	cDirectionLight (const cDirectionLight &);
#endif

	/**
	 * constructor with initialization of position and name
	 	* @param dir initial direction of light source
		* @param state initial state of light source (default: on)
		* @param name name of light source (optional)
	 	*/
	cDirectionLight (
		cEventDispatcher *disp,
		const cVertex &dir, 
		const char *name = NULL);

	/**
	 * constructor with initialization of position, state and name
	 	* @param dir initial direction of light source
		* @param state initial state of light source (default: on)
		* @param name name of light source (optional)
	 	*/
	cDirectionLight (
		cEventDispatcher *disp,
		const cVertex &dir, 
		const teLightState state = LIGHT_ON, 
		const char *name = NULL);

	/**
	 * constructor with initialization of position, color, state 
	 * and name
	 	* @param dir initial direction of light source
		* @param col color of the light source (cADSEColor object)
		*        (emissive color component is not used)
		* @param state initial state of light source (default: on)
		* @param name name of light source (optional)
	 	*/
	cDirectionLight (
		cEventDispatcher *disp,
		const cVertex &dir, 
		const cADSEColor &col,
		const teLightState state = LIGHT_ON, 
		const char *name = NULL);

	/**
	 * destructor
	 	*/
	virtual ~cDirectionLight ();

// OPERATIONS
	// note: translating the light is obtained via functions inherited from
	// cVisibleObject (@see cVisibleObject::MoveBy, cVisibleObject::MoveTo)

	/**
	 * set new direction to point to
		* @param dir new direction
		*/
	virtual void SetDirection (const cVertex &dir);

protected:
	/**
	 * this one performs the actual set up of the light
		*
		* (called by Activate()); separeted to simplify
		* cDirectionLight
		*/
	virtual void ActivateLight ();

	/**
	 * A light is a visible object therefore it needs a drawing function
	 	*
		* Not used here - a DirectionLight cannot be drawn!
	 	*/
	virtual void DrawThisObject ();

	/**
	 * identify an instance of this class if it's got no name
	 	*/
	virtual const char *GetDefaultName () const
	{
		return "cLight";
	}

	/** actual direction */
	cVertex mDirection;
};

#endif	// ifndef cDirectionLight_hh
