/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg cObject.cVisibleObject.cInteractiveObject.cCube*/
/**
 * cube derived from class cInteractiveObject
 *
 * #include "cCube.hh"
 * -lglut
 *
 * @see cInteractiveObject
 * @pkgdoc cObject.cVisibleObject.cInteractiveObject.cCube
 */

#ifndef cCube_hh
#define cCube_hh

#include "cInteractiveObject.hh"

/**
 * Simple cube object.
 	*
	* This object displays a simple cube, either solid or wireframed.
	* glutSolidCube() or glutWireCube() is used to build it.
	* Further, a display list is used to draw the cube.
	*/
class cCube 
:	public cInteractiveObject
{
// LIFECYCLE
public:
	/**
	 * an enum to describe the cube's type (solid or wireframed)
	 	*/
	typedef enum eCubeType {
		CUBE_SOLID,
		CUBE_WIREFRAMED
	} teCubeType;

	/**
	 * default constructor w/ optional object name
	 	* @param name name of object (optional)
	 	*/
	cCube (
		cEventDispatcher *disp,
		const char *name = NULL);

	/**
	 * constructor w/ optional size and object name
	 	* @param size (GLdouble) side length of cube (default: 1.0)
	 	* @param name name of object (optional)
	 	*/
	cCube (
		cEventDispatcher *disp,
		GLdouble size = 1.0, 
		const char *name = NULL);

	/**
	 * default constructor
	 	* @param size (GLdouble) side length of cube
	 	* @param solid (GLboolean) draw solid or wireframe cube (default: solid)
		* @param name name of object (optional)
	 	*/
	cCube (
		cEventDispatcher *disp,
		GLdouble size = 1.0, 
		teCubeType solid = CUBE_SOLID,
		const char *name = NULL);

	/**
	 * default constructor
	 	* @param size (GLdouble) side length of cube
	 	* @param solid (GLboolean) draw solid or wireframe cube (default: solid)
		* @param resolution subdivisions per side
		* @param name name of object (optional)
	 	*/
	cCube (
		cEventDispatcher *disp,
		GLdouble size, 
		teCubeType solid,
		int resolution,
		const char *name = NULL);

	/**
	 * destructor
	 	*/
	virtual ~cCube ();

	/**
	 * initialization function
	 	*/
	virtual int Init ();


protected:	
	/**
	 * drawing function
	 	*/
	virtual void DrawThisObject ();

	/**
	 * return class name
	 	*/
	virtual const char *GetDefaultName () const
	{
		return "cCube";
	}

	/**
	 * create solid cube at given resolution
	 	*/
	void MakeSolidCube ();

	
	/**
	 * create wire framed cube at given resolution
	 	*/
	void MakeWireCube ();

// I don't want to make this private since a cTexturedCube might
// want to access this!

	/** ID of display list which contains the cube */
	GLuint mDisplayList;

	/** Is the cube solid or wireframed? */
	teCubeType mSolid;

	/** side length of cube */
	GLdouble mSize;

	/** resolution of cube, if given */
	int mResolution;
};

#endif	// ifndef cCube_hh
