/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**
 * implementation of class cCube
 *
 * -lglut
	*/

// get glut library functions
#include <GL/glut.h>

#include "cCube.hh"

/**
 * default constructor w/ optional object name
 	* @param name name of object (optional)
	*/
cCube::cCube (
	cEventDispatcher *disp,
	const char *name)
: cInteractiveObject (disp, name),
  mDisplayList (0),
  mSolid (CUBE_SOLID),
  mSize (1.0)
{
	ENTER_OBJECT_METHOD("cCube::cCube (const char *)");
}


/**
 * constructor w/ optional size and object name
 	* @param size size of cube (default: 1.0)
 	* @param name name of object (optional)
	*/
cCube::cCube (
	cEventDispatcher *disp,
	GLdouble size, 
	const char *name)
:	cInteractiveObject (disp, name),
	mDisplayList (0),
	mSolid (CUBE_SOLID),
	mSize (size),
	mResolution (0)
{
	ENTER_OBJECT_METHOD("cCube::cCube (GLdouble, const char *)");
}


/**
 * constructor w/ initialization of size, solid and name
 	* @param size size of cube (default: 1.0)
	* @param solid solid or wire frame? (default: solid)
	* @param name name of object (optional)
 	*/
cCube::cCube (
	cEventDispatcher *disp,
	GLdouble size, 
	teCubeType solid,
	const char *name)
: cInteractiveObject (disp, name), 
  mDisplayList(0),
  mSolid (solid), 
  mSize (size),
  mResolution (0)
{
	ENTER_OBJECT_METHOD ("cCube::cCube (GLdouble size, GLboolean solid)");
	// this is enough (mDisplayList is aquired during Init()
}

/**
 * constructor w/ initialization of size, solid and name
 	* @param size size of cube (default: 1.0)
	* @param solid solid or wire frame? (default: solid)
	* @param resolution subdivisions per side
	* @param name name of object (optional)
 	*/
cCube::cCube (
	cEventDispatcher *disp,
	GLdouble size, 
	teCubeType solid,
	int resolution,
	const char *name)
: cInteractiveObject (disp, name), 
  mDisplayList(0),
  mSolid (solid), 
  mSize (size),
  mResolution (resolution)
{
	ENTER_OBJECT_METHOD ("cCube::cCube (GLdouble size, GLboolean solid)");
	// this is enough (mDisplayList is aquired during Init()
}
/**
 * destructor
 	*/
cCube::~cCube ()
{
	ENTER_OBJECT_METHOD ("cCube::~cCube ()");
	if (mDisplayList != 0)
		glDeleteLists (mDisplayList, 1);
}

/**
 * initialization function (aquires display list and compiles it)
 	*/
int cCube::Init ()
{
	ENTER_OBJECT_METHOD ("cCube::Init ()");

	// generate one display list
	mDisplayList = glGenLists (1);

	if (mDisplayList == 0)
		return -1;

	// now fill some data into the list, but do not display anything
	// (no error checking possible there)
	glNewList (mDisplayList, GL_COMPILE);

	// use GLUT primitive for default resolution
	if (mResolution <= 1)
	{
		if (mSolid == CUBE_SOLID) 
		{
			glutSolidCube (mSize);
		} 
		else 
		{
			glutWireCube (mSize);
		}
	}
	else	// cannot use GLUT, neexd to build the cube "by hand"
	{

		if (mSolid == CUBE_SOLID)
		{
			MakeSolidCube ();
		}
		else
		{
			MakeWireCube ();
		}

	}
	
	glEndList ();	// complete display list

	// call inherited Init (cumpulsory!) after we're set up
	cInteractiveObject::Init ();

	return 0;	// that's all folks - success.
}

void cCube::DrawThisObject ()
{
	ENTER_OBJECT_METHOD ("cCube::DrawThisObject ()");
	glCallList (mDisplayList);
}

/**
 * create solid cube
 	*/
void cCube::MakeSolidCube ()
{
	
}

/**
 * create wire framed cube
 	*/
void cCube::MakeWireCube ()
{
	
}
