/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg cColor */
/**
 * class for RGB(A) Color
 *
 * #include "cColor.hh"
 *
 * -lMesaGL or -lGL
 *
 * @pkgdoc cColor
 */

#ifndef cColor_hh
#define cColor_hh

#include <GL/gl.h>
#include "common.hh"

/**
 * class for RGB(A) color
 	*
 	* This class is used to represent an "OpenGL compatible" color.
	* It is a class of its own (its not derived from anything).
	* It has an operator GLfloat *(), so it can be used directly within
	* calls to glColor3f/glColor4f
	*/
class cColor
{
public:
	/**
	 * default constructor
	 	*/
	cColor ();

	/**
	 * constructor w/ initialization (alpha is optional)
	 	* @param r red component
		* @param g green component
		* @param b blue component
		* @param a alpha component (optional, default = 1.0 = opaque)
		*/
	cColor (GLfloat r, GLfloat g, GLfloat b, GLfloat a = 1.0);

	/**
	 * destructor
	 	*/
	~cColor ();

// OPERATORS
	/**
	 * operator for casting to (GLfloat *)
	 	*/
	operator const GLfloat *() const {
		return const_cast <const GLfloat *>((GLfloat *)mColor.array);
	}

	operator GLfloat *() {
		return (GLfloat *)mColor.array;
	}

// ACCESS
	/**
	 * assign new color
	 	* @param r red component
		* @param g green component
		* @param b blue component
		* @param a alpha component (optional, default = 1.0 = opaque)
		*/
	void SetColor (GLfloat r, GLfloat g, GLfloat b, GLfloat a = 1.0);
	
	/**
	 * retrieve actual color
	 	* @param r reference to variable which will hold red value
		* @param g ... green value
		* @param b ... blue value
		*/
	void GetColor (GLfloat &r, GLfloat &g, GLfloat &b);

	/**
	 * retrieve actual color
	 	* @param r reference to variable which will hold red value
		* @param g ... green value
		* @param b ... blue value
		* @param a ... alpha value
		*/
	void GetColor (GLfloat &r, GLfloat &g, GLfloat &b, GLfloat &a);

	/**
	 * return red value
	 	*/
	GLfloat GetR () const
	{
		return mColor.components.r;
	}

	/**
	 * return green value
	 	*/
	GLfloat GetG () const
	{
		return mColor.components.g;
	}

	/**
	 * return blue value
	 	*/
	GLfloat GetB () const
	{
		return mColor.components.b;
	}

	/**
	 * return alpha value
	 	*/
	GLfloat GetA () const
	{
		return mColor.components.a;
	}

protected:
	/**
	 * union to represent an OpenGL RGB(A)
	 	*/
	union uRgbaColor{

		/** RGBA color represented as it's components */
		struct sComponents {	
			/** red component */
			GLfloat r;
			/** green component */
			GLfloat g;
			/** blue component */
			GLfloat b;
			/** alpha component */
			GLfloat a;
		} components; 

		/** plain array representation */
		GLfloat array[4];	
	} mColor;

};

#endif // ifndef cColor_hh
