/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**
 * class for color representation
 *
 * #include "cColor.hh"
 *
 * -lMesaGL or -lGL
 *
 * This class is used to represent an "OpenGL compatible" color.
 * It is a class of its own (its not derived from anything).
 */

#include "cColor.hh"

/**
 * default constructor
 	*/
cColor::cColor ()
{
	// provide a default
	SetColor (0.1, 0.1, 0.1, 1.0);
}

/**
 * constructor w/ initialization (alpha is optional)
 	* @param r red component
	* @param g green component
	* @param b blue component
	* @param a alpha component (optional, default = 1.0 = opaque)
	*/
cColor::cColor (GLfloat r, GLfloat g, GLfloat b, GLfloat a)
{
	SetColor (r, g, b, a);
}

/**
 * destructor
 	*/
cColor::~cColor ()
{
}

/**
 * assign a new color
 	* @param r red component
	* @param g green component
	* @param b blue component
	* @param a alpha component (optional, default = 1.0 = opaque)
	*/
void cColor::SetColor (GLfloat r, GLfloat g, GLfloat b, GLfloat a)
{
	mColor.components.r = r;
	mColor.components.g = g;
	mColor.components.b = b;
	mColor.components.a = a;
}

/**
 * retrieve actual color
 	* @param r reference to variable which will hold red value
	* @param g ... green value
	* @param b ... blue value
	*/
void cColor::GetColor (GLfloat &r, GLfloat &g, GLfloat &b)
{
	r = mColor.components.r;
	g = mColor.components.g;
	b = mColor.components.b;
}

/**
 * retrieve actual color
 	* @param r reference to variable which will hold red value
	* @param g ... green value
	* @param b ... blue value
	* @param a ... alpha value
	*/
void cColor::GetColor (GLfloat &r, GLfloat &g, GLfloat &b, GLfloat &a)
{
	GetColor (r, g, b);
	a = mColor.components.a;
}
