/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg events.cEvent.cAddressEvent*/
/**
 * an event for transporting an address (pointer)
 *
 * @pkgdoc events.cEvent.cAddressEvent
 */

#ifndef cAddressEvent_hh
#define cAddressEvent_hh

#include "cEvent.hh"

/**
 * a cNamedEvent with a payload (an address)
 */
class cAddressEvent 
: public cEvent
{
public:
	/**
	 * constructor which takes the event's name
	 	* @param name string which contains the event's name
		* @param address void ptr
		*/
	cAddressEvent (
		const string &name = "cAddressEvent", 
		void *address = NULL);

	/**
	 * copy constructor
	 	*/
	cAddressEvent (const cAddressEvent &e);

	/**
	 * destructor
	 	*/
	virtual ~cAddressEvent ();

	/**
	 * clone function
	 	* @return pointer to new allocated cAddressEvent
		*/
	virtual cAddressEvent *Clone () const;

	/**
	 * allow accessing the payload
	 	* @return const reference to cVertex containing the payload
		*/
	virtual void *GetAddress () const;

protected:
	/**
	 * the address to transport
	 	*/
	void *mAddress;
};

#endif	// ifndef cAddressEvent_hh
