/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**
 * implementation of cAddressEvent
 *
 * @pkgdoc events.cEvent.cAddressEvent
 */

#include "cAddressEvent.hh"

/**
 * constructor which takes the event's name
 	* @param name string which contains the event's name
	* @param address void ptr to addressee
	*/
cAddressEvent::cAddressEvent (
	const string &name, 
	void *address)
:	cEvent (name),
	mAddress (address)
{
}

/**
 * copy constructor
 	*/
cAddressEvent::cAddressEvent (const cAddressEvent &e)
:	cEvent (e),
	mAddress (e.mAddress)
{
}

/**
 * destructor
 	*/
cAddressEvent::~cAddressEvent ()
{
}

/**
 * clone function
 	* @return pointer to new allocated cAddressEvent
	*/
cAddressEvent *cAddressEvent::Clone () const
{
	return new cAddressEvent (mName, mAddress);
}

/**
 * allow accessing the payload
 	* @return const reference to cVertex containing the payload
	*/
void *cAddressEvent::GetAddress () const
{
	return mAddress;
}

