/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**@pkg cADSEColor */
/**
 * class for a tupel of ambient, diffuse, specular and emissivecolor
 * (basically just contains four cColor objects)
 *
 * #include "cADSEColor.hh"
 *
 * @pkgdoc cADSEColor
 */

#ifndef cADSEColor_hh
#define cADSEColor_hh

// get cColor declaration
#include "cColor.hh"

/**
 * a simple class for representing ambient, diffuse, specular and
 * emissive color
 *
 * There should be no use in deriving from this class. It's basically
 * a beefed-up struct with four cColor objects in it.
 */
class cADSEColor {
//LIFETIME
public:
	/**
	 * default constructor w/ optional initialization
	 	* @param amb cColor object for ambient color
	 	* @param diff cColor object for diffuse color
	 	* @param spec cColor object for specular color
		* @param em cColor object for emissive color
	 	*/
	cADSEColor (
		const cColor &amb = cColor(),
		const cColor &diff = cColor(),
		const cColor &spec = cColor(),
		const cColor &em = cColor());

	/**
	 * destructor
	 	*/
	~cADSEColor ();

// ACCESS
	/**
	 * provide read-only access to ambient component
	 	* @return const reference to cColor
		*/
	const cColor &Ambient () const;

	/**
	 * provide write access to ambient color
	 	* @return reference to cColor
		*/
	cColor &wAmbient ();

	/**
	 * provide read-only access to diffuse component
	 	* @return const reference to cColor
		*/
	const cColor &Diffuse () const;

	/**
	 * provide write access to diffuse color
	 	* @return reference to cColor
		*/
	cColor &wDiffuse ();

	/**
	 * provide read-only access to emissive component
	 	* @return const reference to cColor
		*/
	const cColor &Specular () const;

	/**
	 * provide write access to specular color
	 	* @return reference to cColor
		*/
	cColor &wSpecular ();

	/**
	 * provide read-only access to emissive component
	 	* @return const reference to cColor
		*/
	const cColor &Emissive () const;

	/**
	 * provide write access to emissive color
	 	* @return reference to cColor
		*/
	cColor &wEmissive ();

protected:
	cColor mAmbient;
	cColor mDiffuse;
	cColor mSpecular;
	cColor mEmissive;
};

#endif	//ifndef cADSEColor_hh
