/* (c) 1999-2000 Tino Schwarze, see COPYING for details */
/**
 * implementation of cADSEColor
 */

#include "cADSEColor.hh"

/**
 * default constructor w/ optional initialization
 	* @param amb ambient color component (optional)
 	* @param diff diffuse color component (optional)
 	* @param spec specular color component (optional)
 	*/
cADSEColor::cADSEColor (
	const cColor &amb,
	const cColor &diff,
	const cColor &spec,
	const cColor &em)
:	mAmbient (amb),
	mDiffuse (diff),
	mSpecular (spec),
	mEmissive (em)
{
}

/**
 * destructor
 	*/
cADSEColor::~cADSEColor ()
{
	// nothing to destruct (we're peaceful)
}

//### ACCESS functions to stored colors ###

// read mAmbient
const cColor &cADSEColor::Ambient () const
{
	return mAmbient;
}

// write mAmbient
cColor &cADSEColor::wAmbient ()
{
	return mAmbient;
}

// read mDiffuse
const cColor &cADSEColor::Diffuse () const
{
	return mDiffuse;
}

// write mDiffuse
cColor &cADSEColor::wDiffuse ()
{
	return mDiffuse;
}

// read mSpecular
const cColor &cADSEColor::Specular () const
{
	return mSpecular;
}

// write mSpecular
cColor &cADSEColor::wSpecular ()
{
	return mSpecular;
}


// read mEmissive
const cColor &cADSEColor::Emissive () const
{
	return mEmissive;
}

// write mEmissive
cColor &cADSEColor::wEmissive ()
{
	return mEmissive;
}
